#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private SignalViperCoil[] cacheSignalViperCoil;
		private SignalViperFangs[] cacheSignalViperFangs;
		private SignalViperPulse[] cacheSignalViperPulse;
		private SignalViperRecon[] cacheSignalViperRecon;
		private SignalViperRush[] cacheSignalViperRush;
		private SignalViperSnap[] cacheSignalViperSnap;
		private SignalViperStrike[] cacheSignalViperStrike;
		private SignalViperVenom[] cacheSignalViperVenom;

		
		public SignalViperCoil SignalViperCoil(SignalViperSensitivity sensitivity, bool showBackground, bool showLabels, bool showCaution, Brush chopColor, Brush cautionColor, Brush clearColor, string licenseKey)
		{
			return SignalViperCoil(Input, sensitivity, showBackground, showLabels, showCaution, chopColor, cautionColor, clearColor, licenseKey);
		}

		public SignalViperFangs SignalViperFangs(SignalViperSensitivity sensitivity, int lineWidth, bool showLabels, string licenseKey)
		{
			return SignalViperFangs(Input, sensitivity, lineWidth, showLabels, licenseKey);
		}

		public SignalViperPulse SignalViperPulse(SignalViperSensitivity sensitivity, SignalViperReconTextSize textSize, bool showContextTable, bool showStreakTable, bool showChopState, SignalViperPulseTablePosition contextTablePosition, SignalViperPulseTablePosition streakTablePosition, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value, SignalViperMTFPeriodType hTF3PeriodType, int hTF3Value, string licenseKey)
		{
			return SignalViperPulse(Input, sensitivity, textSize, showContextTable, showStreakTable, showChopState, contextTablePosition, streakTablePosition, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value, hTF3PeriodType, hTF3Value, licenseKey);
		}

		public SignalViperRecon SignalViperRecon(SignalViperSensitivity sensitivity, SignalViperReconTablePosition tablePosition, SignalViperReconTextSize textSize, bool enableMTF, SignalViperMTFPeriodType lTF1PeriodType, int lTF1Value, SignalViperMTFPeriodType lTF2PeriodType, int lTF2Value, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value)
		{
			return SignalViperRecon(Input, sensitivity, tablePosition, textSize, enableMTF, lTF1PeriodType, lTF1Value, lTF2PeriodType, lTF2Value, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value);
		}

		public SignalViperRush SignalViperRush(SignalViperSensitivity sensitivity, bool showChopDots, bool showCaution, bool showZeroLine, bool showTable)
		{
			return SignalViperRush(Input, sensitivity, showChopDots, showCaution, showZeroLine, showTable);
		}

		public SignalViperSnap SignalViperSnap(SignalViperSensitivity sensitivity, bool showDivLines, bool showDangerZones, bool showLabels)
		{
			return SignalViperSnap(Input, sensitivity, showDivLines, showDangerZones, showLabels);
		}

		public SignalViperStrike SignalViperStrike(SignalViperSensitivity sensitivity, bool allowNeutral, bool showSignals, bool showConfirm, bool showSLTP, bool showCloud)
		{
			return SignalViperStrike(Input, sensitivity, allowNeutral, showSignals, showConfirm, showSLTP, showCloud);
		}

		public SignalViperVenom SignalViperVenom(SignalViperSensitivity sensitivity, bool showMA, bool showZeroLine, bool showTable)
		{
			return SignalViperVenom(Input, sensitivity, showMA, showZeroLine, showTable);
		}


		
		public SignalViperCoil SignalViperCoil(ISeries<double> input, SignalViperSensitivity sensitivity, bool showBackground, bool showLabels, bool showCaution, Brush chopColor, Brush cautionColor, Brush clearColor, string licenseKey)
		{
			if (cacheSignalViperCoil != null)
				for (int idx = 0; idx < cacheSignalViperCoil.Length; idx++)
					if (cacheSignalViperCoil[idx].Sensitivity == sensitivity && cacheSignalViperCoil[idx].ShowBackground == showBackground && cacheSignalViperCoil[idx].ShowLabels == showLabels && cacheSignalViperCoil[idx].ShowCaution == showCaution && cacheSignalViperCoil[idx].ChopColor == chopColor && cacheSignalViperCoil[idx].CautionColor == cautionColor && cacheSignalViperCoil[idx].ClearColor == clearColor && cacheSignalViperCoil[idx].LicenseKey == licenseKey && cacheSignalViperCoil[idx].EqualsInput(input))
						return cacheSignalViperCoil[idx];
			return CacheIndicator<SignalViperCoil>(new SignalViperCoil(){ Sensitivity = sensitivity, ShowBackground = showBackground, ShowLabels = showLabels, ShowCaution = showCaution, ChopColor = chopColor, CautionColor = cautionColor, ClearColor = clearColor, LicenseKey = licenseKey }, input, ref cacheSignalViperCoil);
		}

		public SignalViperFangs SignalViperFangs(ISeries<double> input, SignalViperSensitivity sensitivity, int lineWidth, bool showLabels, string licenseKey)
		{
			if (cacheSignalViperFangs != null)
				for (int idx = 0; idx < cacheSignalViperFangs.Length; idx++)
					if (cacheSignalViperFangs[idx].Sensitivity == sensitivity && cacheSignalViperFangs[idx].LineWidth == lineWidth && cacheSignalViperFangs[idx].ShowLabels == showLabels && cacheSignalViperFangs[idx].LicenseKey == licenseKey && cacheSignalViperFangs[idx].EqualsInput(input))
						return cacheSignalViperFangs[idx];
			return CacheIndicator<SignalViperFangs>(new SignalViperFangs(){ Sensitivity = sensitivity, LineWidth = lineWidth, ShowLabels = showLabels, LicenseKey = licenseKey }, input, ref cacheSignalViperFangs);
		}

		public SignalViperPulse SignalViperPulse(ISeries<double> input, SignalViperSensitivity sensitivity, SignalViperReconTextSize textSize, bool showContextTable, bool showStreakTable, bool showChopState, SignalViperPulseTablePosition contextTablePosition, SignalViperPulseTablePosition streakTablePosition, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value, SignalViperMTFPeriodType hTF3PeriodType, int hTF3Value, string licenseKey)
		{
			if (cacheSignalViperPulse != null)
				for (int idx = 0; idx < cacheSignalViperPulse.Length; idx++)
					if (cacheSignalViperPulse[idx].Sensitivity == sensitivity && cacheSignalViperPulse[idx].TextSize == textSize && cacheSignalViperPulse[idx].ShowContextTable == showContextTable && cacheSignalViperPulse[idx].ShowStreakTable == showStreakTable && cacheSignalViperPulse[idx].ShowChopState == showChopState && cacheSignalViperPulse[idx].ContextTablePosition == contextTablePosition && cacheSignalViperPulse[idx].StreakTablePosition == streakTablePosition && cacheSignalViperPulse[idx].HTF1PeriodType == hTF1PeriodType && cacheSignalViperPulse[idx].HTF1Value == hTF1Value && cacheSignalViperPulse[idx].HTF2PeriodType == hTF2PeriodType && cacheSignalViperPulse[idx].HTF2Value == hTF2Value && cacheSignalViperPulse[idx].HTF3PeriodType == hTF3PeriodType && cacheSignalViperPulse[idx].HTF3Value == hTF3Value && cacheSignalViperPulse[idx].LicenseKey == licenseKey && cacheSignalViperPulse[idx].EqualsInput(input))
						return cacheSignalViperPulse[idx];
			return CacheIndicator<SignalViperPulse>(new SignalViperPulse(){ Sensitivity = sensitivity, TextSize = textSize, ShowContextTable = showContextTable, ShowStreakTable = showStreakTable, ShowChopState = showChopState, ContextTablePosition = contextTablePosition, StreakTablePosition = streakTablePosition, HTF1PeriodType = hTF1PeriodType, HTF1Value = hTF1Value, HTF2PeriodType = hTF2PeriodType, HTF2Value = hTF2Value, HTF3PeriodType = hTF3PeriodType, HTF3Value = hTF3Value, LicenseKey = licenseKey }, input, ref cacheSignalViperPulse);
		}

		public SignalViperRecon SignalViperRecon(ISeries<double> input, SignalViperSensitivity sensitivity, SignalViperReconTablePosition tablePosition, SignalViperReconTextSize textSize, bool enableMTF, SignalViperMTFPeriodType lTF1PeriodType, int lTF1Value, SignalViperMTFPeriodType lTF2PeriodType, int lTF2Value, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value)
		{
			if (cacheSignalViperRecon != null)
				for (int idx = 0; idx < cacheSignalViperRecon.Length; idx++)
					if (cacheSignalViperRecon[idx].Sensitivity == sensitivity && cacheSignalViperRecon[idx].TablePosition == tablePosition && cacheSignalViperRecon[idx].TextSize == textSize && cacheSignalViperRecon[idx].EnableMTF == enableMTF && cacheSignalViperRecon[idx].LTF1PeriodType == lTF1PeriodType && cacheSignalViperRecon[idx].LTF1Value == lTF1Value && cacheSignalViperRecon[idx].LTF2PeriodType == lTF2PeriodType && cacheSignalViperRecon[idx].LTF2Value == lTF2Value && cacheSignalViperRecon[idx].HTF1PeriodType == hTF1PeriodType && cacheSignalViperRecon[idx].HTF1Value == hTF1Value && cacheSignalViperRecon[idx].HTF2PeriodType == hTF2PeriodType && cacheSignalViperRecon[idx].HTF2Value == hTF2Value && cacheSignalViperRecon[idx].EqualsInput(input))
						return cacheSignalViperRecon[idx];
			return CacheIndicator<SignalViperRecon>(new SignalViperRecon(){ Sensitivity = sensitivity, TablePosition = tablePosition, TextSize = textSize, EnableMTF = enableMTF, LTF1PeriodType = lTF1PeriodType, LTF1Value = lTF1Value, LTF2PeriodType = lTF2PeriodType, LTF2Value = lTF2Value, HTF1PeriodType = hTF1PeriodType, HTF1Value = hTF1Value, HTF2PeriodType = hTF2PeriodType, HTF2Value = hTF2Value }, input, ref cacheSignalViperRecon);
		}

		public SignalViperRush SignalViperRush(ISeries<double> input, SignalViperSensitivity sensitivity, bool showChopDots, bool showCaution, bool showZeroLine, bool showTable)
		{
			if (cacheSignalViperRush != null)
				for (int idx = 0; idx < cacheSignalViperRush.Length; idx++)
					if (cacheSignalViperRush[idx].Sensitivity == sensitivity && cacheSignalViperRush[idx].ShowChopDots == showChopDots && cacheSignalViperRush[idx].ShowCaution == showCaution && cacheSignalViperRush[idx].ShowZeroLine == showZeroLine && cacheSignalViperRush[idx].ShowTable == showTable && cacheSignalViperRush[idx].EqualsInput(input))
						return cacheSignalViperRush[idx];
			return CacheIndicator<SignalViperRush>(new SignalViperRush(){ Sensitivity = sensitivity, ShowChopDots = showChopDots, ShowCaution = showCaution, ShowZeroLine = showZeroLine, ShowTable = showTable }, input, ref cacheSignalViperRush);
		}

		public SignalViperSnap SignalViperSnap(ISeries<double> input, SignalViperSensitivity sensitivity, bool showDivLines, bool showDangerZones, bool showLabels)
		{
			if (cacheSignalViperSnap != null)
				for (int idx = 0; idx < cacheSignalViperSnap.Length; idx++)
					if (cacheSignalViperSnap[idx].Sensitivity == sensitivity && cacheSignalViperSnap[idx].ShowDivLines == showDivLines && cacheSignalViperSnap[idx].ShowDangerZones == showDangerZones && cacheSignalViperSnap[idx].ShowLabels == showLabels && cacheSignalViperSnap[idx].EqualsInput(input))
						return cacheSignalViperSnap[idx];
			return CacheIndicator<SignalViperSnap>(new SignalViperSnap(){ Sensitivity = sensitivity, ShowDivLines = showDivLines, ShowDangerZones = showDangerZones, ShowLabels = showLabels }, input, ref cacheSignalViperSnap);
		}

		public SignalViperStrike SignalViperStrike(ISeries<double> input, SignalViperSensitivity sensitivity, bool allowNeutral, bool showSignals, bool showConfirm, bool showSLTP, bool showCloud)
		{
			if (cacheSignalViperStrike != null)
				for (int idx = 0; idx < cacheSignalViperStrike.Length; idx++)
					if (cacheSignalViperStrike[idx].Sensitivity == sensitivity && cacheSignalViperStrike[idx].AllowNeutral == allowNeutral && cacheSignalViperStrike[idx].ShowSignals == showSignals && cacheSignalViperStrike[idx].ShowConfirm == showConfirm && cacheSignalViperStrike[idx].ShowSLTP == showSLTP && cacheSignalViperStrike[idx].ShowCloud == showCloud && cacheSignalViperStrike[idx].EqualsInput(input))
						return cacheSignalViperStrike[idx];
			return CacheIndicator<SignalViperStrike>(new SignalViperStrike(){ Sensitivity = sensitivity, AllowNeutral = allowNeutral, ShowSignals = showSignals, ShowConfirm = showConfirm, ShowSLTP = showSLTP, ShowCloud = showCloud }, input, ref cacheSignalViperStrike);
		}

		public SignalViperVenom SignalViperVenom(ISeries<double> input, SignalViperSensitivity sensitivity, bool showMA, bool showZeroLine, bool showTable)
		{
			if (cacheSignalViperVenom != null)
				for (int idx = 0; idx < cacheSignalViperVenom.Length; idx++)
					if (cacheSignalViperVenom[idx].Sensitivity == sensitivity && cacheSignalViperVenom[idx].ShowMA == showMA && cacheSignalViperVenom[idx].ShowZeroLine == showZeroLine && cacheSignalViperVenom[idx].ShowTable == showTable && cacheSignalViperVenom[idx].EqualsInput(input))
						return cacheSignalViperVenom[idx];
			return CacheIndicator<SignalViperVenom>(new SignalViperVenom(){ Sensitivity = sensitivity, ShowMA = showMA, ShowZeroLine = showZeroLine, ShowTable = showTable }, input, ref cacheSignalViperVenom);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.SignalViperCoil SignalViperCoil(SignalViperSensitivity sensitivity, bool showBackground, bool showLabels, bool showCaution, Brush chopColor, Brush cautionColor, Brush clearColor, string licenseKey)
		{
			return indicator.SignalViperCoil(Input, sensitivity, showBackground, showLabels, showCaution, chopColor, cautionColor, clearColor, licenseKey);
		}

		public Indicators.SignalViperFangs SignalViperFangs(SignalViperSensitivity sensitivity, int lineWidth, bool showLabels, string licenseKey)
		{
			return indicator.SignalViperFangs(Input, sensitivity, lineWidth, showLabels, licenseKey);
		}

		public Indicators.SignalViperPulse SignalViperPulse(SignalViperSensitivity sensitivity, SignalViperReconTextSize textSize, bool showContextTable, bool showStreakTable, bool showChopState, SignalViperPulseTablePosition contextTablePosition, SignalViperPulseTablePosition streakTablePosition, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value, SignalViperMTFPeriodType hTF3PeriodType, int hTF3Value, string licenseKey)
		{
			return indicator.SignalViperPulse(Input, sensitivity, textSize, showContextTable, showStreakTable, showChopState, contextTablePosition, streakTablePosition, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value, hTF3PeriodType, hTF3Value, licenseKey);
		}

		public Indicators.SignalViperRecon SignalViperRecon(SignalViperSensitivity sensitivity, SignalViperReconTablePosition tablePosition, SignalViperReconTextSize textSize, bool enableMTF, SignalViperMTFPeriodType lTF1PeriodType, int lTF1Value, SignalViperMTFPeriodType lTF2PeriodType, int lTF2Value, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value)
		{
			return indicator.SignalViperRecon(Input, sensitivity, tablePosition, textSize, enableMTF, lTF1PeriodType, lTF1Value, lTF2PeriodType, lTF2Value, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value);
		}

		public Indicators.SignalViperRush SignalViperRush(SignalViperSensitivity sensitivity, bool showChopDots, bool showCaution, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperRush(Input, sensitivity, showChopDots, showCaution, showZeroLine, showTable);
		}

		public Indicators.SignalViperSnap SignalViperSnap(SignalViperSensitivity sensitivity, bool showDivLines, bool showDangerZones, bool showLabels)
		{
			return indicator.SignalViperSnap(Input, sensitivity, showDivLines, showDangerZones, showLabels);
		}

		public Indicators.SignalViperStrike SignalViperStrike(SignalViperSensitivity sensitivity, bool allowNeutral, bool showSignals, bool showConfirm, bool showSLTP, bool showCloud)
		{
			return indicator.SignalViperStrike(Input, sensitivity, allowNeutral, showSignals, showConfirm, showSLTP, showCloud);
		}

		public Indicators.SignalViperVenom SignalViperVenom(SignalViperSensitivity sensitivity, bool showMA, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperVenom(Input, sensitivity, showMA, showZeroLine, showTable);
		}


		
		public Indicators.SignalViperCoil SignalViperCoil(ISeries<double> input , SignalViperSensitivity sensitivity, bool showBackground, bool showLabels, bool showCaution, Brush chopColor, Brush cautionColor, Brush clearColor, string licenseKey)
		{
			return indicator.SignalViperCoil(input, sensitivity, showBackground, showLabels, showCaution, chopColor, cautionColor, clearColor, licenseKey);
		}

		public Indicators.SignalViperFangs SignalViperFangs(ISeries<double> input , SignalViperSensitivity sensitivity, int lineWidth, bool showLabels, string licenseKey)
		{
			return indicator.SignalViperFangs(input, sensitivity, lineWidth, showLabels, licenseKey);
		}

		public Indicators.SignalViperPulse SignalViperPulse(ISeries<double> input , SignalViperSensitivity sensitivity, SignalViperReconTextSize textSize, bool showContextTable, bool showStreakTable, bool showChopState, SignalViperPulseTablePosition contextTablePosition, SignalViperPulseTablePosition streakTablePosition, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value, SignalViperMTFPeriodType hTF3PeriodType, int hTF3Value, string licenseKey)
		{
			return indicator.SignalViperPulse(input, sensitivity, textSize, showContextTable, showStreakTable, showChopState, contextTablePosition, streakTablePosition, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value, hTF3PeriodType, hTF3Value, licenseKey);
		}

		public Indicators.SignalViperRecon SignalViperRecon(ISeries<double> input , SignalViperSensitivity sensitivity, SignalViperReconTablePosition tablePosition, SignalViperReconTextSize textSize, bool enableMTF, SignalViperMTFPeriodType lTF1PeriodType, int lTF1Value, SignalViperMTFPeriodType lTF2PeriodType, int lTF2Value, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value)
		{
			return indicator.SignalViperRecon(input, sensitivity, tablePosition, textSize, enableMTF, lTF1PeriodType, lTF1Value, lTF2PeriodType, lTF2Value, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value);
		}

		public Indicators.SignalViperRush SignalViperRush(ISeries<double> input , SignalViperSensitivity sensitivity, bool showChopDots, bool showCaution, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperRush(input, sensitivity, showChopDots, showCaution, showZeroLine, showTable);
		}

		public Indicators.SignalViperSnap SignalViperSnap(ISeries<double> input , SignalViperSensitivity sensitivity, bool showDivLines, bool showDangerZones, bool showLabels)
		{
			return indicator.SignalViperSnap(input, sensitivity, showDivLines, showDangerZones, showLabels);
		}

		public Indicators.SignalViperStrike SignalViperStrike(ISeries<double> input , SignalViperSensitivity sensitivity, bool allowNeutral, bool showSignals, bool showConfirm, bool showSLTP, bool showCloud)
		{
			return indicator.SignalViperStrike(input, sensitivity, allowNeutral, showSignals, showConfirm, showSLTP, showCloud);
		}

		public Indicators.SignalViperVenom SignalViperVenom(ISeries<double> input , SignalViperSensitivity sensitivity, bool showMA, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperVenom(input, sensitivity, showMA, showZeroLine, showTable);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.SignalViperCoil SignalViperCoil(SignalViperSensitivity sensitivity, bool showBackground, bool showLabels, bool showCaution, Brush chopColor, Brush cautionColor, Brush clearColor, string licenseKey)
		{
			return indicator.SignalViperCoil(Input, sensitivity, showBackground, showLabels, showCaution, chopColor, cautionColor, clearColor, licenseKey);
		}

		public Indicators.SignalViperFangs SignalViperFangs(SignalViperSensitivity sensitivity, int lineWidth, bool showLabels, string licenseKey)
		{
			return indicator.SignalViperFangs(Input, sensitivity, lineWidth, showLabels, licenseKey);
		}

		public Indicators.SignalViperPulse SignalViperPulse(SignalViperSensitivity sensitivity, SignalViperReconTextSize textSize, bool showContextTable, bool showStreakTable, bool showChopState, SignalViperPulseTablePosition contextTablePosition, SignalViperPulseTablePosition streakTablePosition, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value, SignalViperMTFPeriodType hTF3PeriodType, int hTF3Value, string licenseKey)
		{
			return indicator.SignalViperPulse(Input, sensitivity, textSize, showContextTable, showStreakTable, showChopState, contextTablePosition, streakTablePosition, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value, hTF3PeriodType, hTF3Value, licenseKey);
		}

		public Indicators.SignalViperRecon SignalViperRecon(SignalViperSensitivity sensitivity, SignalViperReconTablePosition tablePosition, SignalViperReconTextSize textSize, bool enableMTF, SignalViperMTFPeriodType lTF1PeriodType, int lTF1Value, SignalViperMTFPeriodType lTF2PeriodType, int lTF2Value, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value)
		{
			return indicator.SignalViperRecon(Input, sensitivity, tablePosition, textSize, enableMTF, lTF1PeriodType, lTF1Value, lTF2PeriodType, lTF2Value, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value);
		}

		public Indicators.SignalViperRush SignalViperRush(SignalViperSensitivity sensitivity, bool showChopDots, bool showCaution, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperRush(Input, sensitivity, showChopDots, showCaution, showZeroLine, showTable);
		}

		public Indicators.SignalViperSnap SignalViperSnap(SignalViperSensitivity sensitivity, bool showDivLines, bool showDangerZones, bool showLabels)
		{
			return indicator.SignalViperSnap(Input, sensitivity, showDivLines, showDangerZones, showLabels);
		}

		public Indicators.SignalViperStrike SignalViperStrike(SignalViperSensitivity sensitivity, bool allowNeutral, bool showSignals, bool showConfirm, bool showSLTP, bool showCloud)
		{
			return indicator.SignalViperStrike(Input, sensitivity, allowNeutral, showSignals, showConfirm, showSLTP, showCloud);
		}

		public Indicators.SignalViperVenom SignalViperVenom(SignalViperSensitivity sensitivity, bool showMA, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperVenom(Input, sensitivity, showMA, showZeroLine, showTable);
		}


		
		public Indicators.SignalViperCoil SignalViperCoil(ISeries<double> input , SignalViperSensitivity sensitivity, bool showBackground, bool showLabels, bool showCaution, Brush chopColor, Brush cautionColor, Brush clearColor, string licenseKey)
		{
			return indicator.SignalViperCoil(input, sensitivity, showBackground, showLabels, showCaution, chopColor, cautionColor, clearColor, licenseKey);
		}

		public Indicators.SignalViperFangs SignalViperFangs(ISeries<double> input , SignalViperSensitivity sensitivity, int lineWidth, bool showLabels, string licenseKey)
		{
			return indicator.SignalViperFangs(input, sensitivity, lineWidth, showLabels, licenseKey);
		}

		public Indicators.SignalViperPulse SignalViperPulse(ISeries<double> input , SignalViperSensitivity sensitivity, SignalViperReconTextSize textSize, bool showContextTable, bool showStreakTable, bool showChopState, SignalViperPulseTablePosition contextTablePosition, SignalViperPulseTablePosition streakTablePosition, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value, SignalViperMTFPeriodType hTF3PeriodType, int hTF3Value, string licenseKey)
		{
			return indicator.SignalViperPulse(input, sensitivity, textSize, showContextTable, showStreakTable, showChopState, contextTablePosition, streakTablePosition, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value, hTF3PeriodType, hTF3Value, licenseKey);
		}

		public Indicators.SignalViperRecon SignalViperRecon(ISeries<double> input , SignalViperSensitivity sensitivity, SignalViperReconTablePosition tablePosition, SignalViperReconTextSize textSize, bool enableMTF, SignalViperMTFPeriodType lTF1PeriodType, int lTF1Value, SignalViperMTFPeriodType lTF2PeriodType, int lTF2Value, SignalViperMTFPeriodType hTF1PeriodType, int hTF1Value, SignalViperMTFPeriodType hTF2PeriodType, int hTF2Value)
		{
			return indicator.SignalViperRecon(input, sensitivity, tablePosition, textSize, enableMTF, lTF1PeriodType, lTF1Value, lTF2PeriodType, lTF2Value, hTF1PeriodType, hTF1Value, hTF2PeriodType, hTF2Value);
		}

		public Indicators.SignalViperRush SignalViperRush(ISeries<double> input , SignalViperSensitivity sensitivity, bool showChopDots, bool showCaution, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperRush(input, sensitivity, showChopDots, showCaution, showZeroLine, showTable);
		}

		public Indicators.SignalViperSnap SignalViperSnap(ISeries<double> input , SignalViperSensitivity sensitivity, bool showDivLines, bool showDangerZones, bool showLabels)
		{
			return indicator.SignalViperSnap(input, sensitivity, showDivLines, showDangerZones, showLabels);
		}

		public Indicators.SignalViperStrike SignalViperStrike(ISeries<double> input , SignalViperSensitivity sensitivity, bool allowNeutral, bool showSignals, bool showConfirm, bool showSLTP, bool showCloud)
		{
			return indicator.SignalViperStrike(input, sensitivity, allowNeutral, showSignals, showConfirm, showSLTP, showCloud);
		}

		public Indicators.SignalViperVenom SignalViperVenom(ISeries<double> input , SignalViperSensitivity sensitivity, bool showMA, bool showZeroLine, bool showTable)
		{
			return indicator.SignalViperVenom(input, sensitivity, showMA, showZeroLine, showTable);
		}

	}
}

#endregion
